#
# /etc/profile.d/aliases.sh
#

# ls
alias la='ls -lA'
alias ll='ls -l'
alias lh='ls -lh'
alias lr='ls -lR'

# color output
alias ls='ls --color=auto --classify'
alias grep='grep --color=auto'
alias egrep='egrep --color=auto'

# tmux
if [ -x /usr/bin/tmux ]; then
	alias tmux='/usr/bin/tmux new-session -A -s default'
fi

# dvtm and abduco
if [ -x /usr/bin/abduco -a -x /usr/bin/dvtm ]; then
	alias abduco='/usr/bin/abduco -A dvtm'
	alias dvtm='/usr/bin/abduco -A dvtm'
fi

# vis / nvim / vim
if [ -x /usr/bin/vis ]; then
	alias vi='/usr/bin/vis'
elif [ -x /usr/bin/nvim ]; then
	alias vi='/usr/bin/nvim'
elif [ -x /usr/bin/vim ]; then
	alias vi='/usr/bin/vim'
fi
if [ -x /usr/bin/nvim -a ! -x /usr/bin/vim ]; then
	alias vim='/usr/bin/nvim'
fi
alias :q="echo 'You have left vi, this is shell! ;)'"
alias :w=':q'
alias :wq=':q'

# htop
if [ -x /usr/bin/htop ]; then
	alias top='/usr/bin/htop'
fi

# compression
if [ -x /usr/bin/pigz ]; then
	alias gzip='/usr/bin/pigz'
fi
if [ -x /usr/bin/pbzip2 ]; then
	alias bzip2='/usr/bin/pbzip2'
fi

# crontab
if [ -x /usr/bin/crontab ]; then
	alias crontab='crontab -i'
fi

# in-secure shell without host key verification
if [ -x /usr/bin/ssh ]; then
	alias issh='ssh -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no'
	alias isshb='ssh -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no -o BatchMode=yes'
	alias iscp='scp -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no'
	alias iscpb='scp -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no -o BatchMode=yes'
fi

if [ "${USER}" = 'root' -a -x /usr/bin/pacman -a -d /run/systemd/system -a -x /usr/bin/systemd-inhibit ]; then
	alias pacman='systemd-inhibit --why="Package management in progress" pacman'
fi
